<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Group_Discount extends CI_Controller {

    var $main_menu_name = "group_discount";
	var $sub_menu_name = "group_discount";
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('Group_Discount_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Common_Model');
		$this->load->model('Sequerty_Model');
	}

	public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('group_discount/group_discount',$data);
	}
	
	
	public function get_all_group_discount_by_warehouse_id()
	{
		$warehouse_id=$this->input->get('WH');
		$route = $this->Group_Discount_Model->get_all_route_by_warehouse_id($warehouse_id);
		echo json_encode($route);
	}
	
	
	public function save_group_discount()
	{
		$route_id=$this->input->post('route_id');
		$type=$this->input->post('type');
		$route_name=$this->input->post('route_name');
		$route_code=$this->input->post('route_code');
		$data=array(
			'gd_grup_discount_val'=>$route_name,
			'gd_group_code'=>$route_code
		);
		
		$this->load->library('form_validation'); //form validation lib
		if($type=='A')
		{
			$this->form_validation->set_rules('route_code', 'Code', 'required|is_unique[goup_of_discount.gd_group_code]');
			$this->form_validation->set_rules('route_name', 'Value', 'required|is_unique[goup_of_discount.gd_grup_discount_val]');
		}
		else if($type=='E')
		{
			$this->form_validation->set_rules('route_code', 'Code', 'required');
			$this->form_validation->set_rules('route_name', 'Value', 'required');
		}
		
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
		
		$_insert=$this->Group_Discount_Model->save_group_discount($data,$route_id);
		$lastid=$this->db->insert_id();

		if($type=='A'){
			if ($lastid) {
				echo json_encode(array('id'=>$lastid,'type'=>$type));
			} else {
				echo json_encode(array('status'=>'error'));
			}
		}
		if($type=='E'){
			echo json_encode(array('type'=>$type));
		}
		}
	}

	public function add_group_discount()
	{
        if (isset($_GET['route_id'])) {
			$route_id=$_GET['route_id'];
		}
		else {
			$route_id='';
		}
		if($route_id){
			$data['route_id']=$route_id;
			$data['type']='E';
			$data['pageName']='UPDATE Group Discount';
			$data['btnText']='Update Group Discount';
			$data['suppliyer']= $this->Group_Discount_Model->get_group_discount_info($route_id);	
		}
		else {
			$data['route_id']='';
			$data['type']='A';
			$data['pageName']='ADD Group Discount';
			$data['btnText']='Add Group Discount';
		}
        $this->load->view('group_discount/create_group_discount',$data);
	}

	public function list_group_discount()
	{
	$requestData= $_REQUEST;
	
	$columns = array( 
		0 =>'route_code', 
		1 => 'route_name'
	);
	
	$data = array();
	$route = $this->Group_Discount_Model->get_all_group_discount();
	$totalData = count($route);
	$totalFiltered = $totalData;  
	
	foreach ($route as $row){
		$nestedData=array(); 
		$nestedData[] =$row['gd_group_code'];
		$nestedData[] = $row['gd_grup_discount_val'];
		$nestedData[] = "";
		$actionTxtDisble='';
		$actionTxtEnable='';
		$actionTxtUpdate='';
		$actionTxtDelete='';
		$actionTxtUpdate='<a onClick="click_route_update_btn('.$row['gd_id'].')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit suppliers"><i class="glyphicon fa fa-edit"></i></a> &nbsp;';
		if($row['gd_status']==1){
			$actionTxtDisble = '<a class="btn btn-xs btn-green tooltips" data-placement="top" data-original-title="Disable Group Discount" onClick="disableUnitData('.$row['gd_id'].')"><i class="glyphicon fa fa-check"></i></a> &nbsp;';
	}
		if($row['gd_status']==0){
			$actionTxtEnable = '<a class="btn btn-xs btn-warning tooltips" data-placement="top" data-original-title="Disable supplier" onClick="enableUnitData('.$row['gd_id'].')"><i class="glyphicon fa fa-minus-circle"></i></a> &nbsp;';
	}
		$actionTxtDelete='<a class="btn btn-xs btn-bricky tooltips" data-placement="top" data-original-title="Delete supplier" onClick="deleteUnitData('.$row['gd_id'].')">
															<i class="glyphicon fa fa-trash-o"></i></a>';
	
	$nestedData[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtDelete;
	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}


	function delete_group_discount() {
		$route_id	= $this->input->post('route_id');
		$this->Group_Discount_Model->delete_group_discount($route_id);
        if ($route_id) {
        	echo json_encode(array('id'=>$route_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function disable_group_discount() {
		$route_id	= $this->input->post('route_id');
		$this->Group_Discount_Model->disable_group_discount($route_id);
        if ($route_id) {
        	echo json_encode(array('id'=>$route_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function enable_group_discount() {
		$route_id	= $this->input->post('route_id');
		$this->Group_Discount_Model->enable_group_discount($route_id);
        if ($route_id) {
        	echo json_encode(array('id'=>$route_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
}