<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Pos extends CI_Controller
{
    var $main_menu_name = "hw";
    var $sub_menu_name = "";
    public function __construct()
    {
        parent::__construct();
        $this->load->model('pos_model');
        $this->load->model('customer_model');
        $this->load->model('common_model');
        $this->load->model('sales_model');
        $this->load->model('Warehouse_Model');
        $this->load->model('Store_Notes_Model');
        date_default_timezone_set("Asia/Colombo");
    }
    public function index()
    {
        $data['category_by_id_1'] = $this->pos_model->get_product_by_cat_id(1);
        $data['category']         = $this->pos_model->get_all_category();
        $data['sub_category']     = $this->pos_model->get_sub_category_by_cat_id(1);
        $data['get_customer']     = $this->pos_model->get_customer();
        $data['get_warehouse']    = $this->pos_model->get_warehouse();
        $this->load->view('pos/pos', $data);
    }
    function hw_list()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'list';
        $data['customers']   = $this->customer_model->get_all_customers();
        $this->load->view('invoice/hw_list', $data);
    }
    function list_sales()
    {
        $requestData   = $_REQUEST;
        $start         = $this->input->get('start');
        $length        = $this->input->get('length');
        $search        = $this->input->get('search');
        $direct_sale   = $this->input->get('direct_sale');
        $cus_id        = $this->input->get('cus_id');
        $data          = array();
        //$cus_id = ($cus_id == 1)?$cus_id = "":$cus_id;
        $totalData     = $this->pos_model->get_all_sales("", "", $search, $direct_sale,"",$cus_id);
        //$totalData     = $totalData->count;
        //print_r($totalData->count);
        $sales         = $this->pos_model->get_all_sales($start, $length, $search, $direct_sale,"",$cus_id);
        $totalFiltered = $totalData;
        foreach ($sales as $row) {
            $nestedData           = array();
            $sale_id              = $row['sale_id'];
            
            //TOTAL PAID IN CASH
            $total_paid_amount    = $this->pos_model->get_total_paid_by_sale_id($sale_id);
            /*
            return start
            */
            $return_tot           = 0;
            $total_return         = 0;
            $total_return_pymnt   = 0;
            $return_sales_details = $this->pos_model->get_return_sale_info_sale_id($sale_id);
            foreach ($return_sales_details as $row2) {
                $total_return += $row2->sl_rtn_total;
                $total_return_pymnt += $this->pos_model->get_total_return_paid_by_sale_id_by_claim($row2->sl_rtn_id,1);
            }
            /*
            return end
            */
            
            //CUSTOMER BALANCE PAYMENT
            $to_be_paid      = $row['sale_total'] - $total_paid_amount;
            
            $nestedData[]    = display_date_time_format($row['sale_datetime']);
            $nestedData[]    = $row['sale_reference_no'] . " / " . $row['card_ref_number'];
            
            $nestedData[]    = $row['cus_name'];
            //$total_return = 0;
            //grand total | paid | return| pending payment amount
            $nestedData[]    = $row['sale_total'];
            $nestedData[]    = $total_paid_amount;
            $nestedData[]    = $to_be_paid;
            $nestedData[]    = $total_return;
            $nestedData[]    = $total_return_pymnt;
            $nestedData[]    = $total_return - $to_be_paid - $total_return_pymnt;
            
            if (empty($total_paid_amount)) {
                $pay_st = '<span class="label label-warning">Pending</span>';
            } else {
                if ($row['sale_total'] == $total_paid_amount) {
                    $pay_st = '<span class="label label-success">Paid</span>';
                }else if ($row['sale_total'] < $total_paid_amount) {
                    $pay_st = '<span class="label label-danger">OVER PAID</span>';
                } else {
                    $pay_st = '<span class="label label-info">Partial</span>';
                }
            }
            $nestedData[]          = $pay_st;
            $actionTxtDisble       = '';
            $actionTxtEnable       = '';
            $actionTxtUpdate       = '';
            $actionTxtDelete       = '';
            $url                   = base_url("sales/sale_details?sale_id=$sale_id");
            $actionTxtDetails      = '<li><a href="' . base_url() . 'pos/view/' . $sale_id . '"><i class="fa fa-file-text-o"></i> Sale Details </a></li>';
            $actionTxtPrint        = ($total_return >= $row['sale_total']) ? '<li><a onClick="fbs_click(' . $row['sale_id'] . ')" data-toggle="modal" href="#" data-placement="top" data-original-title="Edit suppliers"><i class="fa fa-print"></i> Print Sale</a></li>' : '';
            //$actionTxtUpdate='<a onClick="fbs_click('.$row['sale_id'].')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit suppliers"><i class="clip-zoom-in-2"></i></a> &nbsp;';
            //$actionTxtViewDetails='<a href="'.base_url().'pos/view/'.$sale_id.'" class="btn btn-xs btn-blue tooltips"><i class="fa fa-file-text-o"></i></a> &nbsp;';
            $actionTxtClearInvoice = (!$total_return) ? '<li><a style="cursor:pointer" onClick ="clear_sale(' . $sale_id . ',' . $row['warehouse_id'] . ')"><i class="fa fa-eraser"></i></i><span style="margin-left:2px">Cancel Invoice </span></a></li>' : '';
            $actionTxtReturn       = ($total_return < $row['sale_total']) ? '<li><a href="' . base_url() . 'sales_return/sales_return_add_hw/' . $sale_id . '"><i class="fa fa-file-text-o"></i> Return Sale (Max amount: <strong>Rs' . $total_paid_amount . '</strong> only)</a></li>' : '';
            $actionMenu            = '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                                <ul role="menu" class="dropdown-menu pull-right">
                                ' . $actionTxtDetails . '
                                ' . $actionTxtPrint . '
                                ' . $actionTxtClearInvoice . '
                                ' . $actionTxtReturn . '
                                </ul>
                    </div>
                    ';
            $nestedData[]          = $actionMenu;
            /*if ($total_return>0) 
            {
            $nestedData[] = '<div class="btn-group text-left">
            <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
            <ul role="menu" class="dropdown-menu pull-right">
            <li><a href="'.base_url().'pos/view/'.$sale_id.'"><i class="fa fa-file-text-o"></i> Sale Details</a></li>
            
            <li><a onClick="fbs_click('.$row['sale_id'].')" data-toggle="modal" href="#" data-placement="top" data-original-title="Edit suppliers"><i class="fa fa-print"></i> Print Sale</a></li>
            </ul></div>'; 
            }else //<li><a href="'.base_url().'sales_return/sales_return_add_hw/'.$sale_id.'"><i class="fa fa-file-text-o"></i> Return Sale</a></li>
            {
            $nestedData[] = '<div class="btn-group text-left">
            <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
            <ul role="menu" class="dropdown-menu pull-right">
            <li><a href="'.base_url().'pos/view/'.$sale_id.'"><i class="fa fa-file-text-o"></i> Sale Details</a></li>
            '.$actionTxtReturn.'
            <li>'.$actionTxtClearInvoice.'</li>
            </ul></div>'; 
            }*/
            /*
            <li><a onClick="fbs_click('.$row['sale_id'].')" data-toggle="modal" href="#" data-placement="top" data-original-title="Edit suppliers"><i class="fa fa-print"></i> Print Sale</a></li>
            <li><a href="'.base_url().'sales_return/sales_return_add/'.$sale_id.'"><i class="fa fa-angle-double-left"></i></i> Return Sale</a></li>
            */
            $data[]                = $nestedData;
        }
        $json_data = array(
            //"draw"            => intval( $requestData['draw'] ),  
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    function check_return_balance(){
        $success = false;
        $data = array();
        $ref_id = $this->input->post('ref_id');
        $sale_details   = $this->pos_model->get_sale_info_by_code($ref_id);
        $sale_id = $sale_details['sale_id'];
        
        $total_return = 0;
        $total_return_pymnt = 0;
        
        //TOTAL PAID IN CASH
        $total_paid_amount    = $this->pos_model->get_total_paid_by_sale_id($sale_id);
        $return_sales_details = $this->pos_model->get_return_sale_info_sale_id($sale_id);
        foreach ($return_sales_details as $row2) {
            $total_return += $row2->sl_rtn_total;
            $total_return_pymnt += $this->pos_model->get_total_return_paid_by_sale_id_by_claim($row2->sl_rtn_id,1);
        }
        
        //CUSTOMER BALANCE PAYMENT
        $to_be_paid      = $sale_details['sale_total'] - $total_paid_amount;
        $grand_liability = $total_return - $to_be_paid - $total_return_pymnt;
        
        $data['balance'] = $grand_liability;
        $data['sale_id'] = $sale_id;
        
        if($grand_liability > 0) $success = true;
        $json_data = array(
            "success" =>$success,
            "data" => $data
        );
        echo json_encode($json_data);
    }
    function claim_return_balance($ref_id){
        if(!$ref_id)return false;
        $success = false;
        $data = array();
        // $ref_id = $this->input->post('ref_id');
        $sale_details   = $this->pos_model->get_sale_info_by_code($ref_id);
        $sale_id = $sale_details['sale_id'];
        
        $return_sales_details = $this->pos_model->get_return_sale_info_sale_id($sale_id);
        foreach ($return_sales_details as $row2) {
            $return_pymnts = $this->pos_model->get_total_return_paid_list($row2->sl_rtn_id,0);
            foreach($return_pymnts as $row3){
                $this->pos_model->claim_return_payment($row3->sale_pymnt_id);
            }
        }
        
        /*
        //CUSTOMER BALANCE PAYMENT
        $to_be_paid      = $sale_details['sale_total'] - $total_paid_amount;
        $grand_liability = $total_return - $to_be_paid - $total_return_pymnt;
        
        $data['balance'] = $grand_liability;
        $data['sale_id'] = $sale_id;
        
        if($grand_liability > 0) $success = true;
        $json_data = array(
            "success" =>$success,
            "data" => $data
        );
        echo json_encode($json_data);*/
    }
    public function vk()
    {
        $this->load->view("pos/vk");
    }
    public function ajaxcategorydata($category_id = '')
    {
        $category_id = $this->input->get('category_id');
        $out_cat     = '';
        $out_sub     = '';
        $d           = $this->pos_model->get_product_by_cat_id($category_id);
        $s           = $this->pos_model->get_sub_category_by_cat_id($category_id);
        if (!empty($d)) {
            foreach ($d as $key => $prod) {
                $out_cat .= "<button data-container='body' class='btn-prni btn-default product pos-tip' title='" . $prod->product_name . "' product_cost='" . $prod->product_cost . "'  value='" . $prod->product_code . "' type='button' id='product-" . $prod->product_id . "' style='font-weight:bold; font-size:12px; height:120px; min-width:150px'> 
                <div class='row' style='height:100%'>                                                      
                    <div class='col-xs-7' style='height:100%'>
                        <img class='img-rounded' style='height:113px;' width='90px' alt='" . $prod->product_name . "' src='" . asset_url() . "uploads/thumbs/" . $prod->product_thumb . "'>
                    </div>

<div class='col-xs-5' style='height:100%'>" . substr($prod->product_name, 0, 20) . "<br>" . $prod->product_price . "
                </div>
                </div>
                </button>";
                /*--------------
                OLD CAT BUTTON
                --------------*/
                /*
                $out_cat.="<button data-container='body' class='btn-prni btn-default product pos-tip' title='".$prod->product_name."'  value='".$prod->product_code."' type='button' id='product-".$prod->product_id."'><img class='img-rounded' style='width:60px;height:60px;' alt='".$prod->product_name."' src='".asset_url()."uploads/thumbs/".$prod->product_thumb."'><span>".$prod->product_name."</span></button>;"
                */
                /*--------------
                OLD CAT BUTTON END
                -----------*/
            }
            if (!empty($s)) {
                foreach ($s as $key => $sub_cat) {
                    $out_sub .= "<button id='subcategory-" . $sub_cat->sub_cat_id . "' type='button' value='" . $sub_cat->sub_cat_id . "' class='btn-prni subcategory' ><img src='" . asset_url() . "uploads/no-image.jpg' style='width:60px;height:60px;' class='img-rounded img-thumbnail'/><span>" . $sub_cat->sub_cat_name . "</span></button>";
                    /*-------------
                    OLD SUB CAT BUTTON
                    --------------------*/
                    /*
                    $out_sub.="<button id='subcategory-".$sub_cat->sub_cat_id."' type='button' value='".$sub_cat->sub_cat_id."' class='btn-prni subcategory' ><img src='".asset_url()."uploads/no-image.jpg' style='width:60px;height:60px;' class='img-rounded img-thumbnail'/><span>".$sub_cat->sub_cat_name."</span></button>";
                    */
                    /*---------------
                    OLD SUB CAT BUTTON END
                    */
                }
                $jproduct = array(
                    "products" => $out_cat,
                    "subcategories" => $out_sub,
                    "tcp" => count($key)
                );
                $ret      = json_encode($jproduct);
                echo $ret;
            } else {
                $jproduct = array(
                    "products" => $out_cat,
                    "subcategories" => "",
                    "tcp" => count($key)
                );
                $ret      = json_encode($jproduct);
                echo $ret;
            }
        } else {
            $jproduct = array(
                "products" => "<div></div>",
                "subcategories" => "",
                "tcp" => 0
            );
            $ret      = json_encode($jproduct);
            echo $ret;
        }
    }
    public function ajaxproducts($category_id = '', $subcategory_id = '', $per_page = '')
    {
        $nm             = '';
        $category_id    = $this->input->get('category_id');
        $subcategory_id = $this->input->get('subcategory_id');
        $n              = $this->pos_model->get_product_by_cat_sub_id($category_id, $subcategory_id);
        if (!empty($n)) {
            foreach ($n as $key => $pro) {
                $nm .= "<button data-container='body' class='btn-prni btn-default product pos-tip' title='" . $pro->product_name . "'  product_cost='" . $prod->product_cost . "'  value='" . $pro->product_code . "' type='button' id='product-" . $pro->product_id . "' style='font-weight:bold; font-size:12px; height:120px; min-width:150px'> 
                
<div class='row  col-xs-12' style='height:100%'>                                                      

<div class='col-xs-8' style='height:100%;'><img class='img-rounded' style='height:113px; width:90px; margin-left:-16px;' alt='" . $pro->product_name . "' src='" . asset_url() . "uploads/thumbs/" . $pro->product_thumb . "'></div>

<div class='col-xs-4' style='height:100%; text-align:left; margin-left:0px;'>" . $pro->product_name . "<br>" . $pro->product_price . "</div>
                </div>
                </button>";
                /*----------
                OLD SUB CLICK RESULT GEN
                ----------*/
                /*
                $nm.="<button data-container='body' class='btn-prni btn-default product pos-tip' title='' value='".$pro->product_code."' type='button' id='product-".$pro->product_id."'><img class='img-rounded' style='width:60px;height:60px;' alt='".$pro->product_name."' src='".asset_url()."uploads/thumbs/".$pro->product_thumb."'><span>".$pro->product_name."</span></button>";
                */
                /*
                END OLD SUB CLICK RESULT GEN
                */
            }
            echo $nm;
        } else {
            echo "<div></div>";
        }
    }
    public function getProductDataByCode()
    {
        $emp_array             = array();
        $product_code          = $this->input->get('code');
        $customer_id           = $this->input->get('customer_id');
        $warehouse_id          = $this->input->get('warehouse_id');
        $get_product_all_by_id = $this->pos_model->get_product_by_code($product_code, $customer_id, $warehouse_id);
        if (!empty($get_product_all_by_id)) {
            $empar = array();
            foreach ($get_product_all_by_id as $key => $value) {
                $r     = $get_product_all_by_id[$key];
                $lb    = $get_product_all_by_id[$key]->product_name;
                $label = array(
                    "id" => mt_rand(10, 10000),
                    "item_id" => $get_product_all_by_id[$key]->product_id,
                    "label" => $get_product_all_by_id[$key]->product_code . ' | ' . $get_product_all_by_id[$key]->product_name,
                    "qty" => 1,
                    'row' => $r,
                    'value' => $get_product_all_by_id[$key]->product_name
                );
                array_push($empar, $label);
            }
            echo json_encode($empar);
        } else {
            echo '[{"id":0,"label":"No matching result found! Product might be out of stock in the selected warehouse.","value":"hg"}]';
        }
    }
    public function pos_submit()
    {
        if (is_logged_in()) {
        } else {
            redirect(base_url(), 'refresh');
            exit();
        }
        $customer_id               = $this->input->post('poscustomer');
        $poswarehouse              = $this->input->post('poswarehouse');
        $discount                  = $this->input->post('discount');
        $pos_discount_input        = $this->input->post('pos_discount_input1');
        $pay_amount                = $this->input->post('pay_amount'); //$this->input->post('pay_amount');
        $grand_total               = $this->input->post('grand_total');
        $paid_by                   = $this->input->post('paid_by');
        $cc_no                     = $this->input->post('cc_no');
        $pcc_holder                = $this->input->post('cc_holder');
        $pcc_type                  = $this->input->post('cc_type');
        $payment_note              = $this->input->post('payment_note');
        $cheque_no                 = $this->input->post('cheque_no');
        $cheque_date               = $this->input->post('cheque_date');
        $shipping                  = $this->input->post('posshipping');
        $sale_date                 = date("Y-m-d H:i:s");
        $price_type                = $this->input->post('price_type');
        $query                     = $this->pos_model->get_new_next_ref_no($price_type);
        $result                    = $query->row();
        $sale_ref                  = sprintf("%05d", $result->count + 1);
        $pr_id                     = $this->input->post('product_id');
        $bid                       = $this->input->post('bid');
        $product_code              = $this->input->post('product_code');
        $product_name              = $this->input->post('product_name');
        $net_price                 = $this->input->post('net_price');
        $ssubtotal                 = $this->input->post('ssubtotal');
        $quantity                  = $this->input->post('quantity');
        $product_cost              = $this->input->post('cost');
        $discount_val              = $this->input->post('discount_val');
        $sale_pymnt_balane_amount  = $this->input->post('balance_amount');
        $discount_i                = $this->input->post('discount_i');
        $total_item_discount_value = $this->input->post('total_item_discount');
        $total_cost_val            = $this->input->post('total_cost_val');
        $is_phone_bill             = $this->input->post('is_phone_bill');
        $address_input             = $this->input->post('shipping_address');
        $cash_cus_name             = $this->input->post('cash_cus_name');
        $invoice_type              = $this->input->post('invoice_type');
        $price_type                = $this->input->post('price_type');
        $sale_pymnt_given_amount   = $this->input->post('cash_en');
        $cc_charges                = $this->input->post('cc_charges');
        $broker_id                 = $this->input->post('broker_id');
        $print_del                 = $this->input->post('print_del');
        if ($price_type == "retail_cash")
            $sale_ref = "CS" . $sale_ref;
        else if ($price_type == "retail_credit")
            $sale_ref = "CR" . $sale_ref;
        else if ($price_type == "retail_wholesale")
            $sale_ref = "WH" . $sale_ref;
        if ($sale_pymnt_given_amount > 0) {
        } else
            $sale_pymnt_given_amount = 0;
        if ($sale_pymnt_given_amount >= $grand_total) {
            $pay_amount = $grand_total;
        } else {
            $pay_amount = $sale_pymnt_given_amount;
        }
        $data    = array(
            'sale_reference_no' => $sale_ref,
            'warehouse_id' => $poswarehouse,
            'customer_id' => $customer_id,
            'sale_datetime' => $sale_date,
            'sale_note' => "",
            'sale_inv_total' => $grand_total - $total_item_discount_value - $shipping,
            'sale_total' => $grand_total - $total_item_discount_value,
            'cost_total' => $total_cost_val,
            'sale_inv_discount' => $pos_discount_input,
            'sale_inv_discount_amount' => $discount,
            'paid_by' => $paid_by,
            'sale_datetime_created' => $sale_date,
            'delivery_charge' => $shipping,
            //'is_phone_bill'                => $is_phone_bill,    
            'sale_shipping' => $address_input,
            'cash_cus_name' => $cash_cus_name,
            'invoice_type' => $invoice_type,
            'price_type' => $price_type,
            'cr_interest' => 3,
            'cr_interest_amt' => $cc_charges,
            'sale_given_amount' => $sale_pymnt_given_amount,
            'user_id' => $this->session->userdata('ss_user_id'),
            'broker_id' => $broker_id,
            'is_del' => $print_del,
            'float_id' => $this->session->userdata('ss_cashier_float_id')
        );
        //print_r($data);
        $sale_id = $this->pos_model->save_sale_header($data);
        if ($sale_id) {
            /**
             * save sale items
             */
            for ($i = 0; $i < count($pr_id); $i++) {
                $data2 = array(
                    'sale_id' => $sale_id,
                    'product_id' => $pr_id[$i],
                    'batch_id' => $bid[$i],
                    'quantity' => $quantity[$i],
                    'unit_price' => $net_price[$i],
                    'item_cost' => $product_cost[$i],
                    'gross_total' => $ssubtotal[$i],
                    'discount' => $discount_i[$i],
                    'discount_val' => $discount_val[$i],
                    'total_item_cost' => $product_cost[$i] * $quantity[$i]
                );
                $this->pos_model->sale_items_in($data2);
                /*set delivery items*/
                //1
                if ($this->input->post('stnn1')) {
                    $this->common_model->update_stn($this->input->post('stnn1_wh'), $this->input->post('stnn1'), $sale_id);
                    $deli_ok = $this->input->post('deliveryList_' . $pr_id[$i] . '_' . $bid[$i]);
                    //print_r($deli_ok);
                    if ($deli_ok) {
                        $stn_data = array(
                            'stn_no' => $this->input->post('stnn1'),
                            //'stn_code'        => $this->input->post('stnn1_code'),
                            //'sale_id'       => $sale_id,
                            'product_id' => $pr_id[$i],
                            'quantity' => $quantity[$i],
                            'stn_wh_id' => $this->input->post('stnn1_wh')
                        );
                        $this->common_model->save_stn_items($stn_data);
                    }
                }
                //2
                if ($this->input->post('stnn2')) {
                    $this->common_model->update_stn($this->input->post('stnn2_wh'), $this->input->post('stnn2'), $sale_id);
                    $deli_ok = $this->input->post('deliveryList2_' . $pr_id[$i] . '_' . $bid[$i]);
                    //print_r($deli_ok);
                    if ($deli_ok) {
                        $stn_data = array(
                            'stn_no' => $this->input->post('stnn2'),
                            //'stn_code'        => $this->input->post('stnn1_code'),
                            //'sale_id'       => $sale_id,
                            'product_id' => $pr_id[$i],
                            'quantity' => $quantity[$i],
                            'stn_wh_id' => $this->input->post('stnn2_wh')
                        );
                        $this->common_model->save_stn_items($stn_data);
                    }
                }
                //3
                if ($this->input->post('stnn3')) {
                    $this->common_model->update_stn($this->input->post('stnn3_wh'), $this->input->post('stnn3'), $sale_id);
                    $deli_ok = $this->input->post('deliveryList3_' . $pr_id[$i] . '_' . $bid[$i]);
                    //print_r($deli_ok);
                    if ($deli_ok) {
                        $stn_data = array(
                            'stn_no' => $this->input->post('stnn3'),
                            //'stn_code'        => $this->input->post('stnn1_code'),
                            //'sale_id'       => $sale_id,
                            'product_id' => $pr_id[$i],
                            'quantity' => $quantity[$i],
                            'stn_wh_id' => $this->input->post('stnn3_wh')
                        );
                        $this->common_model->save_stn_items($stn_data);
                    }
                }
                /*end set delivery items*/
            }
            //print_r("STOP");
            /**
             * Payments
             */
            if ($pay_amount > 0) {
                $data = array(
                    'sale_id' => $sale_id,
                    'sale_pymnt_paying_by' => $paid_by,
                    'sale_pymnt_amount' => $pay_amount,
                    'sale_pymnt_date_time' => $sale_date,
                    'sale_pymnt_added_date_time' => $sale_date,
                    'sale_pymnt_crdt_card_no' => $cc_no[0],
                    'sale_pymnt_crdt_card_holder_name' => $pcc_holder[0],
                    'sale_pymnt_crdt_card_type' => $pcc_type[0],
                    'sale_pymnt_cheque_no' => $cheque_no[0],
                    'sale_pymnt_cheque_date' => $cheque_date[0],
                    'sale_pymnt_note' => $payment_note[0],
                    'sale_payment_type' => "hw_sale",
                    'float_id' => $this->session->userdata('ss_cashier_float_id')
                );
                $t    = $this->pos_model->sales_payment($data);
            } else {
                $t = 0;
            }
            /**
             * Store Notes
             */
            /*if($this->input->post('stnn1')){
            $this->common_model->update_stn($this->input->post('stnn1_wh'),$this->input->post('stnn1'), $sale_id);
            $deliveryList = $this->input->post('deliveryList');
            for($c = 0; $c < count($deliveryList); $c++){
            for ($i=0; $i < count($pr_id); $i++) {
            if($deliveryList[$c] === $pr_id[$i]){
            $stn_data = array(
            'stn_no'        => $this->input->post('stnn1'),
            //'stn_code'        => $this->input->post('stnn1_code'),
            //'sale_id'       => $sale_id,
            'product_id'     => $pr_id[$i],
            'quantity'        => $quantity[$i],
            'stn_wh_id'        => $this->input->post('stnn1_wh'),
            );
            $this->common_model->save_stn_items($stn_data);
            }else
            continue;
            }                    
            }
            }
            
            if($this->input->post('stnn2')){
            $this->common_model->update_stn($this->input->post('stnn2_wh'),$this->input->post('stnn2'), $sale_id);
            $deliveryList = $this->input->post('deliveryList2');
            for($c = 0; $c < count($deliveryList); $c++){
            for ($i=0; $i < count($pr_id); $i++) {
            if($deliveryList[$c] === $pr_id[$i]){
            $stn_data = array(
            'stn_no'        => $this->input->post('stnn2'),
            //'stn_code'        => $this->input->post('stnn1_code'),
            //'sale_id'       => $sale_id,
            'product_id'     => $pr_id[$i],
            'quantity'        => $quantity[$i],
            'stn_wh_id'        => $this->input->post('stnn2_wh'),
            );
            $this->common_model->save_stn_items($stn_data);
            }else
            continue;
            }                    
            }
            }
            if($this->input->post('stnn3')){
            $this->common_model->update_stn($this->input->post('stnn3_wh'),$this->input->post('stnn3'), $sale_id);
            $deliveryList = $this->input->post('deliveryList3');
            for($c = 0; $c < count($deliveryList); $c++){
            for ($i=0; $i < count($pr_id); $i++) {
            if($deliveryList[$c] === $pr_id[$i]){
            $stn_data = array(
            'stn_no'        => $this->input->post('stnn3'),
            //'stn_code'        => $this->input->post('stnn1_code'),
            //'sale_id'       => $sale_id,
            'product_id'     => $pr_id[$i],
            'quantity'        => $quantity[$i],
            'stn_wh_id'        => $this->input->post('stnn3_wh'),
            );
            $this->common_model->save_stn_items($stn_data);
            }else
            continue;
            }                    
            }
            }*/
            /* $data2 = array(
            'sale_id'       => $sale_id,
            'product_id'     => $pr_id[$i],
            'quantity'        => $quantity[$i],
            'unit_price'    => $net_price[$i],
            'item_cost'        => $product_cost[$i],
            'gross_total'   => $ssubtotal[$i],
            'discount'        => $discount_i[$i],
            'discount_val'    =>$discount_val[$i],
            'total_item_cost'    =>$product_cost[$i]*$quantity[$i],
            ); */
            //$this->pos_model->sale_items_in($data2);
            /* if ($t == 1) {
            
            $data['sale_id']    = $sale_id;
            $data['pay_amount']    = $pay_amount;
            $data['paid_by']    = $paid_by;
            $data['balance_amount']    = $sale_pymnt_balane_amount;    
            
            echo json_encode(array(
            'sale_id' => $sale_id,
            'sale_ref' => $sale_ref,
            'error' => '0',
            'disMsg' => ''
            ));                
            
            } else {
            echo json_encode(array(
            'sale_id' => $sale_id,
            'sale_ref' => $sale_ref,
            'error' => '0',
            'disMsg' => ''
            ));
            } */
            echo json_encode(array(
                'sale_id' => $sale_id,
                'sale_ref' => $sale_ref,
                'error' => '0',
                'disMsg' => ''
            ));
        }
    }
    
    public function pos_submit_development()
    {
        if (is_logged_in()) {
        } else {
            redirect(base_url(), 'refresh');
            exit();
        }
        $disMsg = "Error occured!";
        $success = false;
        $customer_id               = $this->input->post('poscustomer');
        $poswarehouse              = $this->input->post('poswarehouse');
        $discount                  = $this->input->post('discount');
        $pos_discount_input        = $this->input->post('pos_discount_input1');
        $payments                  = $this->input->post('amount');//$this->input->post('pay_amount');
        $paid_amount               = $this->input->post('total_paid');//$this->input->post('pay_amount');
        $grand_total               = $this->input->post('grand_total');
        $paid_by                   = $this->input->post('paid_by');
        $cc_no                     = $this->input->post('cc_no');
        $pcc_holder                = $this->input->post('cc_holder');
        $pcc_type                  = $this->input->post('cc_type');
        $payment_note              = $this->input->post('payment_note');
        $cheque_no                 = $this->input->post('cheque_no');
        $cheque_date               = $this->input->post('cheque_date');
        $shipping                  = $this->input->post('posshipping');
        $sale_date                 = date("Y-m-d H:i:s");
        $price_type                = $this->input->post('price_type');
        $query                     = $this->pos_model->get_new_next_ref_no($price_type);
        $result                    = $query->row();
        $sale_ref                  = sprintf("%05d", $result->count + 1);
        $pr_id                     = $this->input->post('product_id');
        $bid                       = $this->input->post('bid');
        $product_code              = $this->input->post('product_code');
        $product_name              = $this->input->post('product_name');
        $net_price                 = $this->input->post('net_price');
        $ssubtotal                 = $this->input->post('ssubtotal');
        $quantity                  = $this->input->post('quantity');
        $product_cost              = $this->input->post('cost');
        $discount_val              = $this->input->post('discount_val');
        $sale_pymnt_balane_amount  = $this->input->post('balance_amount');
        $discount_i                = $this->input->post('discount_i');
        $total_item_discount_value = $this->input->post('total_item_discount');
        $total_cost_val            = $this->input->post('total_cost_val');
        $is_phone_bill             = $this->input->post('is_phone_bill');
        $address_input             = $this->input->post('shipping_address');
        $cash_cus_name             = $this->input->post('cash_cus_name');
        $invoice_type              = $this->input->post('invoice_type');
        $price_type                = $this->input->post('price_type');
        $sale_pymnt_given_amount   = $this->input->post('total_given');
        $cc_charges                = $this->input->post('cc_charges');
        $broker_id                 = $this->input->post('broker_id');
        $print_del                 = $this->input->post('print_del');
        $paying_return_sales       = $this->input->post('paying_gift_card_no');
        $token                     = $this->input->post('token');
        if ($price_type == "retail_cash"){
            $sale_ref = "CS" . $sale_ref;
            if ($sale_pymnt_given_amount < $grand_total) {
                header('Content-type: application/json');
                echo json_encode(array(
                    'success' => false,
                    'data'=> array(
                        'sale_id' => 0,
                        'sale_ref' => '',
                        'disMsg' => 'Given amount is less than paying amount!'
                    )
                ));
                exit;
            }
        }
        else if ($price_type == "retail_credit")
            $sale_ref = "CR" . $sale_ref;
        else if ($price_type == "retail_wholesale"){
            $sale_ref = "WH" . $sale_ref;
            if ($sale_pymnt_given_amount < $grand_total) {
                header('Content-type: application/json');
                echo json_encode(array(
                    'success' => false,
                    'data'=> array(
                        'sale_id' => 0,
                        'sale_ref' => '',
                        'disMsg' => 'Given amount is less than paying amount!'
                    )
                ));
                exit;
            }
        }
        
        /*if ($sale_pymnt_given_amount > 0) {
            
        } else
            $sale_pymnt_given_amount = 0;*/
        
        /**/
        
        $data    = array(
            'sale_reference_no' => $sale_ref,
            'warehouse_id' => $poswarehouse,
            'customer_id' => $customer_id,
            'sale_datetime' => $sale_date,
            'sale_note' => "",
            'sale_inv_total' => $grand_total - $total_item_discount_value - $shipping,
            'sale_total' => $grand_total - $total_item_discount_value,
            'total_paid' => $paid_amount,
            'cost_total' => $total_cost_val,
            'sale_inv_discount' => $pos_discount_input,
            'sale_inv_discount_amount' => $discount,
            //'paid_by' => $paid_by[0],
            'sale_datetime_created' => $sale_date,
            'delivery_charge' => $shipping,
            //'is_phone_bill'                => $is_phone_bill,    
            'sale_shipping' => $address_input,
            'cash_cus_name' => $cash_cus_name,
            'invoice_type' => $invoice_type,
            'price_type' => $price_type,
            'cr_interest' => 3,
            'cr_interest_amt' => $cc_charges,
            'sale_given_amount' => $sale_pymnt_given_amount,
            'user_id' => $this->session->userdata('ss_user_id'),
            'broker_id' => $broker_id,
            'is_del' => $print_del,
            'float_id' => $this->session->userdata('ss_cashier_float_id'),
            'token' => $token
        );
        
        $sale_id = $this->pos_model->save_sale_header($data);
        if ($sale_id) {
            /**
             * save sale items
             */
            for ($i = 0; $i < count($pr_id); $i++) {
                $data2 = array(
                    'sale_id' => $sale_id,
                    'product_id' => $pr_id[$i],
                    'batch_id' => $bid[$i],
                    'quantity' => $quantity[$i],
                    'unit_price' => $net_price[$i],
                    'item_cost' => $product_cost[$i],
                    'gross_total' => $ssubtotal[$i],
                    'discount' => $discount_i[$i],
                    'discount_val' => $discount_val[$i],
                    'total_item_cost' => $product_cost[$i] * $quantity[$i]
                );
                $this->pos_model->sale_items_in($data2);
                /*set delivery items*/
                //1
                if ($this->input->post('stnn1')) {
                    $this->common_model->update_stn($this->input->post('stnn1_wh'), $this->input->post('stnn1'), $sale_id);
                    $deli_ok = $this->input->post('deliveryList_' . $pr_id[$i] . '_' . $bid[$i]);
                    //print_r($deli_ok);
                    if ($deli_ok) {
                        $stn_data = array(
                            'stn_no' => $this->input->post('stnn1'),
                            //'stn_code'        => $this->input->post('stnn1_code'),
                            //'sale_id'       => $sale_id,
                            'product_id' => $pr_id[$i],
                            'quantity' => $quantity[$i],
                            'stn_wh_id' => $this->input->post('stnn1_wh')
                        );
                        $this->common_model->save_stn_items($stn_data);
                    }
                }
                //2
                if ($this->input->post('stnn2')) {
                    $this->common_model->update_stn($this->input->post('stnn2_wh'), $this->input->post('stnn2'), $sale_id);
                    $deli_ok = $this->input->post('deliveryList2_' . $pr_id[$i] . '_' . $bid[$i]);
                    //print_r($deli_ok);
                    if ($deli_ok) {
                        $stn_data = array(
                            'stn_no' => $this->input->post('stnn2'),
                            //'stn_code'        => $this->input->post('stnn1_code'),
                            //'sale_id'       => $sale_id,
                            'product_id' => $pr_id[$i],
                            'quantity' => $quantity[$i],
                            'stn_wh_id' => $this->input->post('stnn2_wh')
                        );
                        $this->common_model->save_stn_items($stn_data);
                    }
                }
                //3
                if ($this->input->post('stnn3')) {
                    $this->common_model->update_stn($this->input->post('stnn3_wh'), $this->input->post('stnn3'), $sale_id);
                    $deli_ok = $this->input->post('deliveryList3_' . $pr_id[$i] . '_' . $bid[$i]);
                    //print_r($deli_ok);
                    if ($deli_ok) {
                        $stn_data = array(
                            'stn_no' => $this->input->post('stnn3'),
                            //'stn_code'        => $this->input->post('stnn1_code'),
                            //'sale_id'       => $sale_id,
                            'product_id' => $pr_id[$i],
                            'quantity' => $quantity[$i],
                            'stn_wh_id' => $this->input->post('stnn3_wh')
                        );
                        $this->common_model->save_stn_items($stn_data);
                    }
                }
                /*end set delivery items*/
            }
            /**
             * Payments
             */
            $paid_by    = $this->input->post('paid_by');
            for ($i = 0; $i < count($paid_by); $i++) {
                if ($payments[$i] > 0) {
                    if($paying_return_sales[$i])
                        $payment_note[$i] = $payment_note[$i].'<br> Sale Reference No '.$paying_return_sales[$i];
                    $data = array(
                        'sale_id' => $sale_id,
                        'sale_pymnt_paying_by' => $paid_by[$i],
                        'sale_pymnt_amount' => $payments[$i],
                        'sale_pymnt_date_time' => $sale_date,
                        'sale_pymnt_added_date_time' => $sale_date,
                        'sale_pymnt_crdt_card_no' => $cc_no[$i],
                        'sale_pymnt_crdt_card_holder_name' => $pcc_holder[$i],
                        'sale_pymnt_crdt_card_type' => $pcc_type[$i],
                        'sale_pymnt_cheque_no' => $cheque_no[$i],
                        'sale_pymnt_cheque_date' => $cheque_date[$i],
                        'sale_pymnt_note' => $payment_note[$i],
                        'sale_payment_type' => "hw_sale",
                        'float_id' => $this->session->userdata('ss_cashier_float_id')
                    );
                    $t    = $this->pos_model->sales_payment($data);
                    $this->claim_return_balance($paying_return_sales[$i]);
                } else {
                    $t = 0;
                }
            }
        
            $disMsg = "Sale added successfully";
            $success = true;
        }
        header('Content-type: application/json');
        echo json_encode(array(
            'success' => $success,
            'data'=> array(
                'sale_id' => $sale_id,
                'sale_ref' => $sale_ref,
                'disMsg' => $disMsg
            )
        ));
    }
    public function pos_submit_production()
    {
        if (is_logged_in()) {
        } else {
            redirect(base_url(), 'refresh');
            exit();
        }
        $disMsg = "Error occured!";
        $success = false;
        $customer_id               = $this->input->post('poscustomer');
        $poswarehouse              = $this->input->post('poswarehouse');
        $discount                  = $this->input->post('discount');
        $pos_discount_input        = $this->input->post('pos_discount_input1');
        $payments                  = $this->input->post('amount');//$this->input->post('pay_amount');
        $paid_amount               = $this->input->post('total_paid');//$this->input->post('pay_amount');
        $grand_total               = $this->input->post('grand_total');
        $paid_by                   = $this->input->post('paid_by');
        $cc_no                     = $this->input->post('cc_no');
        $pcc_holder                = $this->input->post('cc_holder');
        $pcc_type                  = $this->input->post('cc_type');
        $payment_note              = $this->input->post('payment_note');
        $cheque_no                 = $this->input->post('cheque_no');
        $cheque_date               = $this->input->post('cheque_date');
        $shipping                  = $this->input->post('posshipping');
        $sale_date                 = date("Y-m-d H:i:s");
        $price_type                = $this->input->post('price_type');
        $query                     = $this->pos_model->get_new_next_ref_no($price_type);
        $result                    = $query->row();
        $sale_ref                  = sprintf("%05d", $result->count + 1);
        $pr_id                     = $this->input->post('product_id');
        $bid                       = $this->input->post('bid');
        $product_code              = $this->input->post('product_code');
        $product_name              = $this->input->post('product_name');
        $net_price                 = $this->input->post('net_price');
        $ssubtotal                 = $this->input->post('ssubtotal');
        $quantity                  = $this->input->post('quantity');
        $product_cost              = $this->input->post('cost');
        $discount_val              = $this->input->post('discount_val');
        $sale_pymnt_balane_amount  = $this->input->post('balance_amount');
        $discount_i                = $this->input->post('discount_i');
        $total_item_discount_value = $this->input->post('total_item_discount');
        $total_cost_val            = $this->input->post('total_cost_val');
        $is_phone_bill             = $this->input->post('is_phone_bill');
        $address_input             = $this->input->post('shipping_address');
        $cash_cus_name             = $this->input->post('cash_cus_name');
        $invoice_type              = $this->input->post('invoice_type');
        $price_type                = $this->input->post('price_type');
        $sale_pymnt_given_amount   = $this->input->post('total_given');
        $cc_charges                = $this->input->post('cc_charges');
        $broker_id                 = $this->input->post('broker_id');
        $print_del                 = $this->input->post('print_del');
        $paying_return_sales       = $this->input->post('paying_gift_card_no');
        $token                     = $this->input->post('token');
        if ($price_type == "retail_cash"){
            $sale_ref = "CS" . $sale_ref;
            if ($sale_pymnt_given_amount < $grand_total) {
                header('Content-type: application/json');
                echo json_encode(array(
                    'success' => false,
                    'data'=> array(
                        'sale_id' => 0,
                        'sale_ref' => '',
                        'disMsg' => 'Given amount is less than paying amount!'
                    )
                ));
                exit;
            }
        }
        else if ($price_type == "retail_credit")
            $sale_ref = "CR" . $sale_ref;
        else if ($price_type == "retail_wholesale"){
            $sale_ref = "WH" . $sale_ref;
            if ($sale_pymnt_given_amount < $grand_total) {
                header('Content-type: application/json');
                echo json_encode(array(
                    'success' => false,
                    'data'=> array(
                        'sale_id' => 0,
                        'sale_ref' => '',
                        'disMsg' => 'Given amount is less than paying amount!'
                    )
                ));
                exit;
            }
        }
        
        $data    = array(
            'sale_reference_no' => $sale_ref,
            'warehouse_id' => $poswarehouse,
            'customer_id' => $customer_id,
            'sale_datetime' => $sale_date,
            'sale_note' => "",
            'sale_inv_total' => $grand_total - $total_item_discount_value - $shipping,
            'sale_total' => $grand_total - $total_item_discount_value,
            'total_paid' => $paid_amount,
            'cost_total' => $total_cost_val,
            'sale_inv_discount' => $pos_discount_input,
            'sale_inv_discount_amount' => $discount,
            //'paid_by' => $paid_by[0],
            'sale_datetime_created' => $sale_date,
            'delivery_charge' => $shipping,
            //'is_phone_bill'                => $is_phone_bill,    
            'sale_shipping' => $address_input,
            'cash_cus_name' => $cash_cus_name,
            'invoice_type' => $invoice_type,
            'price_type' => $price_type,
            'cr_interest' => 3,
            'cr_interest_amt' => $cc_charges,
            'sale_given_amount' => $sale_pymnt_given_amount,
            'user_id' => $this->session->userdata('ss_user_id'),
            'broker_id' => $broker_id,
            'is_del' => $print_del,
            'float_id' => $this->session->userdata('ss_cashier_float_id'),
            'token' => $token
        );
        
        $sale_id = $this->pos_model->save_sale_header($data);
        if ($sale_id) {
            /**
             * save sale items
             */
            for ($i = 0; $i < count($pr_id); $i++) {
                $data2 = array(
                    'sale_id' => $sale_id,
                    'product_id' => $pr_id[$i],
                    'batch_id' => $bid[$i],
                    'quantity' => $quantity[$i],
                    'unit_price' => $net_price[$i],
                    'item_cost' => $product_cost[$i],
                    'gross_total' => $ssubtotal[$i],
                    'discount' => $discount_i[$i],
                    'discount_val' => $discount_val[$i],
                    'total_item_cost' => $product_cost[$i] * $quantity[$i]
                );
                $this->pos_model->sale_items_in($data2);
                /*set delivery items*/
                //1
                if ($this->input->post('stnn1')) {
                    $this->common_model->update_stn($this->input->post('stnn1_wh'), $this->input->post('stnn1'), $sale_id);
                    $deli_ok = $this->input->post('deliveryList_' . $pr_id[$i] . '_' . $bid[$i]);
                    //print_r($deli_ok);
                    if ($deli_ok) {
                        $stn_data = array(
                            'stn_no' => $this->input->post('stnn1'),
                            //'stn_code'        => $this->input->post('stnn1_code'),
                            //'sale_id'       => $sale_id,
                            'product_id' => $pr_id[$i],
                            'quantity' => $quantity[$i],
                            'stn_wh_id' => $this->input->post('stnn1_wh')
                        );
                        $this->common_model->save_stn_items($stn_data);
                    }
                }
                //2
                if ($this->input->post('stnn2')) {
                    $this->common_model->update_stn($this->input->post('stnn2_wh'), $this->input->post('stnn2'), $sale_id);
                    $deli_ok = $this->input->post('deliveryList2_' . $pr_id[$i] . '_' . $bid[$i]);
                    //print_r($deli_ok);
                    if ($deli_ok) {
                        $stn_data = array(
                            'stn_no' => $this->input->post('stnn2'),
                            //'stn_code'        => $this->input->post('stnn1_code'),
                            //'sale_id'       => $sale_id,
                            'product_id' => $pr_id[$i],
                            'quantity' => $quantity[$i],
                            'stn_wh_id' => $this->input->post('stnn2_wh')
                        );
                        $this->common_model->save_stn_items($stn_data);
                    }
                }
                //3
                if ($this->input->post('stnn3')) {
                    $this->common_model->update_stn($this->input->post('stnn3_wh'), $this->input->post('stnn3'), $sale_id);
                    $deli_ok = $this->input->post('deliveryList3_' . $pr_id[$i] . '_' . $bid[$i]);
                    //print_r($deli_ok);
                    if ($deli_ok) {
                        $stn_data = array(
                            'stn_no' => $this->input->post('stnn3'),
                            //'stn_code'        => $this->input->post('stnn1_code'),
                            //'sale_id'       => $sale_id,
                            'product_id' => $pr_id[$i],
                            'quantity' => $quantity[$i],
                            'stn_wh_id' => $this->input->post('stnn3_wh')
                        );
                        $this->common_model->save_stn_items($stn_data);
                    }
                }
                /*end set delivery items*/
            }
            /**
             * Payments
             */
            $paid_by    = $this->input->post('paid_by');
            for ($i = 0; $i < count($paid_by); $i++) {
                if ($payments[$i] > 0) {
                    //$pn = "";
                    if($paying_return_sales[$i])
                        $payment_note[$i] = $payment_note[$i].'<br> Sale Reference No '.$paying_return_sales[$i];
                    $data = array(
                        'sale_id' => $sale_id,
                        'sale_pymnt_paying_by' => $paid_by[$i],
                        'sale_pymnt_amount' => $payments[$i],
                        'sale_pymnt_date_time' => $sale_date,
                        'sale_pymnt_added_date_time' => $sale_date,
                        'sale_pymnt_crdt_card_no' => $cc_no[$i],
                        'sale_pymnt_crdt_card_holder_name' => $pcc_holder[$i],
                        'sale_pymnt_crdt_card_type' => $pcc_type[$i],
                        'sale_pymnt_cheque_no' => $cheque_no[$i],
                        'sale_pymnt_cheque_date' => $cheque_date[$i],
                        'sale_pymnt_note' => $payment_note[$i],
                        'sale_payment_type' => "hw_sale",
                        'float_id' => $this->session->userdata('ss_cashier_float_id')
                    );
                    $t    = $this->pos_model->sales_payment($data);
                    $this->claim_return_balance($paying_return_sales[$i]);
                } else {
                    $t = 0;
                }
            }
        
            $disMsg = "Sale added successfully";
            $success = true;
        }
        header('Content-type: application/json');
        echo json_encode(array(
            'success' => $success,
            'data'=> array(
                'sale_id' => $sale_id,
                'sale_ref' => $sale_ref,
                'disMsg' => $disMsg
            )
        ));
    }
    public function view_bill()
    {
        $data['category_by_id_1'] = $this->pos_model->get_product_by_cat_id(1);
        $data['category']         = $this->pos_model->get_all_category();
        $data['sub_category']     = $this->pos_model->get_sub_category_by_cat_id(1);
        $data['get_customer']     = $this->pos_model->get_customer();
        $data['get_warehouse']    = $this->pos_model->get_warehouse();
        $this->load->view('pos/pos-bill', $data);
        //$this->load->view('pos/view_bill');
    }
    function get_customers()
    {
        $srh_customer_id = $this->input->get('srh_customer_id');
        $customers       = $this->pos_model->get_customers($srh_customer_id);
        echo json_encode($customers);
    }
    public function sale_print()
    {
        $data['sale_id']        = $this->input->get('sale_id');
        $data['pay_amount']     = $this->input->get('pay_amount');
        $data['paid_by']        = $this->input->get('paid_by');
        $data['balance_amount'] = $this->input->get('balance_amount');
        $this->load->view('pos_print_nav', $data);
    }
    function view()
    {
        $this->load->model('Bank_Model');
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = '';
        $sale_id                = $this->uri->segment('3');
        $data['sale_item_list'] = $this->pos_model->get_sale_item_list_by_sale_id($sale_id);
        if ($data['sale_item_list']) {
            $data['sale_details']       = $this->pos_model->get_sale_info($sale_id);
            $data['total_paid_amount']  = $this->pos_model->get_total_paid_by_sale_id($sale_id);
            $data['customer_details']   = $this->customer_model->get_customer_info($data['sale_details']['customer_id']);
            $data['warehouse_details']  = $this->Warehouse_Model->get_warehouse_info($data['sale_details']['warehouse_id']);
            $data['sale_payments_list'] = $this->pos_model->get_sale_payments_by_sale_id($sale_id);
            $data['bank_list']          = $this->Bank_Model->get_all_bank();
            $old_payment_tot            = 0;
            $retured_payment_tot        = 0;
            $retured_payment_msg_this   = '';
            $old_payments_dis_msg_this  = '';
            $return_sales_details       = $this->pos_model->get_return_sale_info_sale_id($sale_id);
            foreach ($return_sales_details as $row) {
                $this_balance_pament      = 0;
                $this_trn_amt             = $row->sl_rtn_total;
                $retured_payment_tot      = $retured_payment_tot + $this_trn_amt;
                $retured_payment_msg_this = $retured_payment_msg_this . ' -' . $this_trn_amt . ' ,';
            }
            $old_payment_tot              = $old_payment_tot - $retured_payment_tot;
            $data['old_payments']         = $old_payment_tot;
            $data['old_payments_dis_msg'] = "Return Total Amount ($old_payments_dis_msg_this $retured_payment_msg_this)";
            $data['sale_id']              = $sale_id;
            $this->load->view('invoice/hw_sales_details', $data);
        } else
            show_404();
    }
    function sale_details()
    {
        $sale_type                  = 0;
        $sale_id                    = $this->input->get('sale_id');
        $sale_type                  = $this->input->get('type');
        $data['sale_details']       = $this->pos_model->get_sale_info($sale_id);
        $data['sale_type']          = $sale_type;
        //get sale item list
        $data['sale_item_list']     = $this->pos_model->get_sale_item_list_by_sale_id($sale_id);
        $data['customer_details']   = $this->customer_model->get_customer_info($data['sale_details']['customer_id']);
        $data['warehouse_details']  = $this->Warehouse_Model->get_warehouse_info($data['sale_details']['warehouse_id']);
        $data['sale_payments_list'] = $this->pos_model->get_sale_payments_by_sale_id($sale_id);
        //    if($data['sale_details']['customer_id'] != 1)
        //    $data['total_sales']=     $this->pos_model->get_all_sales_for_view($data['sale_details']['warehouse_id'],$data['sale_details']['customer_id']);
        //    if($data['sale_details']['customer_id'] != 1)
        //    $data['total_return'] = $this->pos_model->get_all_sales_return_for_view($data['sale_details']['warehouse_id'],'','',$data['sale_details']['customer_id']);        
        //    $data['total_payments'] = $this->pos_model->getPaymentsForView($data['sale_details']['warehouse_id'],'','','sale','Return_Cash','',$data['sale_details']['customer_id']);        
        //get old payments amounts
        //    $old_payment_tot=$old_payment_tot-$retured_payment_tot;        
        //    $data['old_payments']=$old_payment_tot;
        //    $data['old_payments_dis_msg']="Return Total Amount ($old_payments_dis_msg_this $retured_payment_msg_this)";        
        //    $data['cr_limit_list'] = $this->Common_Model->get_all_cr_limit();        
        //    $paid_amount_=$this->Sales_Model->get_total_paid_amount_($sale_id);
        //    $data['paid_amount_'] = $paid_amount_;    
        if ($this->session->userdata("ss_user_id") == 1) {
            $data['stn_list'] = $this->Store_Notes_Model->get_sore_notes_by_sale_id($sale_id);
            //echo "<pre>";
            //print_r($data['stn_list']);
            //foreach($data['stn_list'] as $rw)
            // print_r($this->Store_Notes_Model->get_store_note_items($rw['warehouse_id'],$rw['stn_no']));
            //echo "</pre>";
            $this->load->view('models/view_bill_model_with_stn', $data);
        } else
            $this->load->view('models/view_bill_model', $data);
    }
    function sale_details_stn()
    {
        $sale_type                  = 0;
        $sale_id                    = $this->input->get('sale_id');
        $sale_type                  = $this->input->get('type');
        $stn                        = $this->input->get('stn');
        $data['sale_details']       = $this->pos_model->get_sale_info($sale_id);
        $data['sale_type']          = $sale_type;
        $data['sale_item_list']     = $this->pos_model->get_sale_item_list_by_sale_id($sale_id);
        $data['customer_details']   = $this->customer_model->get_customer_info($data['sale_details']['customer_id']);
        $data['warehouse_details']  = $this->Warehouse_Model->get_warehouse_info($data['sale_details']['warehouse_id']);
        $data['sale_payments_list'] = $this->pos_model->get_sale_payments_by_sale_id($sale_id);
        $data['stn_list']           = $this->Store_Notes_Model->get_sore_notes_by_sale_id($sale_id);
        /*echo "<pre>";
        print_r( $data['stn_list']);
        */
        if ($stn)
            $this->load->view('models/view_bill_model_with_stn', $data);
        else
            $this->load->view('models/view_bill_model_without_stn', $data);
    }
    function clear_sale()
    {
        $sale_id      = $this->input->post('sale_id');
        $warehouse_id = $this->input->post('warehouse_id');
        $result       = $this->pos_model->clear_sale($sale_id, $warehouse_id);
        return $result;
    }
    function suggetions()
    {
        /*$this->load->model('Customer_Order_Process_Model');
        $this->load->model('Transfer_Model');
        $this->load->model('Purchases_Model');
        $this->load->model('Product_Damage_Model');
        $this->load->model('Sales_Return_Model');
        $this->load->model('Sales_Model');*/
        $this->load->model('Pos_Model');
        $this->load->model('stock_counter_model');
        $term       = $this->input->get('term');
        $is_barcode = $this->input->get('is_barcode');
        $product    = $this->Pos_Model->product_suggetions($term, $is_barcode);
        $in_type    = $this->input->get('t');
        if (!empty($product)) {
            $json = array();
            foreach ($product as $row) {
                $warehouse_id         = ""; // $this->session->userdata('ss_warehouse_id');
                //stock check    
                $product_id           = $row['product_id'];
                $product_code         = $row['product_code'];
                $product_name         = $row['product_name'];
                $product_cost         = $row['product_cost'];
                $cash_price           = $row['retail_cash'];
                $wholesale_price      = $row['retail_wholesale'];
                $credit_salling_price = $row['retail_credit'];
                $pt                   = "retail_cash,retail_credit,retail_wholesale";
                if ($in_type == "retail_cash") {
                    $product_price = $cash_price;
                    $pt            = "retail_cash";
                }
                if ($in_type == "retail_credit") {
                    $product_price = $credit_salling_price;
                    $pt            = "retail_credit";
                }
                if ($in_type == "retail_wholesale") {
                    $product_price = $wholesale_price;
                    $pt            = "retail_wholesale";
                }
                /*$sendParameters  = "$product_id,$product_name,$product_code,$product_price";
                $selling_R_price = " Selling Price: " . number_format($product_price, 2, '.', ',') . ' Cost Price:' . number_format($product_cost, 2, '.', ','); //RETAIL PRICE
                $selling_W_price = " Selling Price(Wholesale): " . number_format($wholesale_price, 2, '.', ','); //WHOLESALE PRICE
                $selling_C_price = " Selling Price(Credit): " . number_format($credit_salling_price, 2, '.', ','); //CREDIT PRICE
                */
                $bdata = $this->Pos_Model->bdata(($row['sub_product_of']) ? $row['sub_product_of'] : $row['product_id'], $pt);
                foreach ($bdata as $key => $btc) {
                    $bdata[$key]['qty'] = $this->stock_counter_model->get_stock_balance_batch($warehouse_id, ($row['sub_product_of']) ? $row['sub_product_of'] : $row['product_id'], $btc['batch_id']);
                    if ($row['sub_product_of']) {
                        $pr_quantity                  = $this->stock_counter_model->get_pr_qty($row['sub_product_of']);
                        $bdata[$key]['uqty']          = $this->get_unit_qty($row['unit_name'], $pr_quantity, $bdata[$key]['qty']);
                        $bdata[$key]['product_price'] = $row[$pt];
                    } else
                        $bdata[$key]['uqty'] = $this->get_unit_qty($row['unit_name'], $row['pr_quantity'], $bdata[$key]['qty']);
                }
                $json_itm = array(
                    'product_id' => $row['product_id'],
                    'product_code' => $row['product_code'],
                    'product_name' => $row['product_name'],
                    'product_cost' => $row['product_cost'],
                    'value' => $row['product_name'] . " (" . $row['product_code'] . ")" . " / Batches :" . count($bdata),
                    'qty' => 1,
                    'wh' => $row['warehouse_id'],
                    'ao' => $row['ao'],
                    'unit' => $row['unit_name'],
                    'bc' => count($bdata),
                    'bdata' => $bdata
                );
                if (count($bdata) > 0)
                    array_push($json, $json_itm);
                    //else echo "skipped ".$row['product_code']." \n";
            }
            header('Content-type: application/json');
            echo json_encode($json);
        } else {
            //echo "HERE 2\n";
            $json         = array();
            $warehouse_id = "";
            if ($is_barcode) {
                $result = $this->stock_counter_model->get_bid($term);
                if (isset($result->batch_id)) {
                    $batch_id             = $result->batch_id;
                    $product_id           = $result->product_id;
                    $cash_price           = $result->retail_cash;
                    $wholesale_price      = $result->retail_wholesale;
                    $credit_salling_price = $result->retail_credit;
                    $pt                   = "retail_cash,retail_credit,retail_wholesale";
                    if ($in_type == "retail_cash") {
                        $pt = "retail_cash";
                    }
                    if ($in_type == "retail_credit") {
                        $pt = "retail_credit";
                    }
                    if ($in_type == "retail_wholesale") {
                        $pt = "retail_wholesale";
                    }
                    $bdata = $this->Pos_Model->bdata(($result->sub_product_of) ? $result->sub_product_of : $result->product_id, $pt, $batch_id);
                    foreach ($bdata as $key => $btc) {
                        $bdata[$key]['qty'] = $this->stock_counter_model->get_stock_balance_batch($warehouse_id, ($result->sub_product_of) ? $result->sub_product_of : $result->product_id, $batch_id);
                        if ($result->sub_product_of) {
                            $pr_quantity                  = $this->stock_counter_model->get_pr_qty($result->sub_product_of);
                            $bdata[$key]['uqty']          = $this->get_unit_qty($result->unit_name, $pr_quantity, $bdata[$key]['qty']);
                            $bdata[$key]['product_price'] = $result->$pt;
                        } else
                            $bdata[$key]['uqty'] = $this->get_unit_qty($result->unit_name, $result->pr_quantity, $bdata[$key]['qty']);
                    }
                    $json_itm = array(
                        'product_id' => $product_id,
                        'product_code' => $result->product_code,
                        'product_name' => $result->product_name,
                        'product_cost' => $result->product_cost,
                        'value' => $result->product_name . " (" . $result->product_code . ")" . " / Batches :" . count($bdata),
                        'qty' => 1,
                        'wh' => $result->warehouse_id,
                        'ao' => $result->ao,
                        'unit' => $result->unit_name,
                        'bc' => count($bdata),
                        'bdata' => $bdata
                    );
                    array_push($json, $json_itm);
                }
            }
            header('Content-type: application/json');
            echo json_encode($json);
        }
    }
    function get_unit_qty($unit_name, $uquantity, $qty)
    {
        $return_name = "";
        /*switch ($unit_name) {
        case "FT":
        $return_name = ($quantity*$quantity);
        break;
        default:
        "";
        }*/
        $return_name = round($uquantity * $qty) . $unit_name;
        //echo $return_name;
        return $return_name;
    }
    function get_stock()
    {
        $this->load->model('stock_counter_model');
        $warehouse_id = $this->input->get('wh');
        $product_id   = $this->input->get('pr');
        $batch_id     = $this->input->get('bt');
        echo $this->stock_counter_model->get_stock_balance_batch_test($warehouse_id, $product_id, $batch_id);
    }
}