<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Products extends CI_Controller
{
    var $main_menu_name = "products";
    var $sub_menu_name = "products";
    public function __construct()
    {
        parent::__construct();
        $this->load->model('category_models');
        $this->load->model('product_models');
        $this->load->model('common_model');
        $this->load->model('Sales_Model');
        $this->load->model('Transfer_Model');
        $this->load->model('Purchases_Model');
        $this->load->model('Product_Damage_Model');
        $this->load->model('Sales_Return_Model');
        $this->load->model('Customer_Order_Process_Model');
        $this->load->model('Product_Discount_Model');
        $this->load->model('Bulk_Break_Model');
        $this->load->model('Pos_Model');
        $this->load->model('Warehouse_Model');
        $this->load->model('Broker_Model');
    }
    public function index()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = $this->sub_menu_name;
        $this->load->view('product/products', $data);
    }
    public function add_product()
    {
        
        $this->load->model('Supplier_Model');
        $data['suppliers'] = $this->Supplier_Model->get_all_supplier();
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'add_products';
        $data['main_category']  = $this->category_models->getCategory();
        $data['unit_type']      = $this->product_models->getUnit();
        $data['tax']            = $this->product_models->getTax();
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('product/add_product', $data);
    }
    public function get_sub_category_by_id()
    {
        $parent_category = $this->input->get('category_id');
        if ($parent_category) {
            $val = $this->category_models->get_sub_category($this->input->get('category_id'));
            if (!empty($val)) {
                echo '<select name="subcategory" id="subcategory" class="form-control search-select">';
                echo "<option value=''></option>";
                foreach ($val as $key => $lst) {
                    echo "<option value='$lst->sub_cat_id'>$lst->sub_cat_name</option>";
                }
                echo '</select>';
            }
        } else {
            echo NULL;
        }
    }
    function save_product()
    {
        $this->load->library('form_validation'); //form validation lib
        $this->form_validation->set_rules('product_name', 'Product Name', 'required');
        $this->form_validation->set_rules('product_code', 'Product Code', 'required|is_unique[product.product_code]');
        $this->form_validation->set_rules('product_cost', 'Product Cost', 'required');
        $this->form_validation->set_rules('supp_id', 'Supplier', 'required');
        $is_hw = $this->input->post('is_hw');
        if ($is_hw) {
            $this->form_validation->set_rules('retail_cash', 'Hardware Cash Price', 'required');
            //$this->form_validation->set_rules('retail_credit', 'credit price', 'required');
            //$this->form_validation->set_rules('retail_wholesale', 'wholesale price', 'required');
        } else {
            $this->form_validation->set_rules('product_price', 'Distribution Cash Price', 'required');
            //$this->form_validation->set_rules('wholesale_price', 'wholesale price', 'required');
            //$this->form_validation->set_rules('credit_salling_price', 'credit salling price', 'required');
        }
        //$this->form_validation->set_rules('alert_quty', 'alert quty', 'required');
        //$this->form_validation->set_rules('daily_rental_days', 'Daily Rental Days', 'required');
        //$this->form_validation->set_rules('daily_rental_days', 'Daily Rental Days', 'required');
        if ($this->form_validation->run() == FALSE) {
            $st = array(
                'status' => 0,
                'validation' => validation_errors()
            );
            echo json_encode($st);
        } else {
            $product_name  = $this->input->post('product_name');
            $product_code  = $this->input->post('product_code');
            $supp_id       = $this->input->post('supp_id');
            $category      = $this->input->post('category');
            $subcategory   = $this->input->post('subcategory');
            $unit          = $this->input->post('unit');
            $product_cost  = $this->price_filter($this->input->post('product_cost'));
            $product_price = $this->input->post('product_price');
            if ($product_price)
                $product_price = $this->price_filter($product_price);
            //else $product_price = 0;
            $wholesale_price = $this->input->post('wholesale_price');
            if ($wholesale_price)
                $wholesale_price = $this->price_filter($wholesale_price);
            //else $wholesale_price = 0;
            $credit_salling_price = $this->input->post('credit_salling_price');
            if ($credit_salling_price)
                $credit_salling_price = $this->price_filter($credit_salling_price);
            //else $credit_salling_price = 0;
            $retail_cash = $this->input->post('retail_cash');
            if ($retail_cash)
                $retail_cash = $this->price_filter($retail_cash);
            //else $retail_cash = 0;
            $retail_credit = $this->input->post('retail_credit');
            if ($retail_credit)
                $retail_credit = $this->price_filter($retail_credit);
            //else $retail_credit = 0;
            $retail_wholesale = $this->input->post('retail_wholesale');
            if ($retail_wholesale)
                $retail_wholesale = $this->price_filter($retail_wholesale);
            //else $retail_wholesale = 0;
            $brand_id                = $this->input->post('brand_id');
            $tax                     = $this->input->post('tax');
            $alert_quty              = $this->input->post('alert_quty');
            //$image_name             = $this->input->post('product_image');
            $product_details         = $this->input->post('product_details');
            $product_part_no         = $this->input->post('product_part_no');
            $product_oem_part_number = $this->input->post('product_oem_part_number');
            $product_id              = $this->input->post('product_id');
            $store_position          = $this->input->post('store_position');
            $product_max_qty         = $this->input->post('product_max_qty');
            $daily_rental_days       = $this->input->post('daily_rental_days');
            $tax                     = $this->input->post('tax');
            $warehouse_id            = $this->input->post("warehouse_id");
            $quantity                = $this->input->post("pr_quantity");
            $group_discount         =  $this->input->post("group_discount");
            
            
            $rep_commisison          = ""; //$this->price_filter($this->input->post('rep_commisison'));            
            $down_payment            = ""; //$this->price_filter($this->input->post('down_payment'));
            $per_day_rental          = ""; //$this->price_filter($this->input->post('per_day_rental'));
            $pd                      = array(
                'cat_id' => $category,
                'sub_cat_id' => $subcategory,
                'product_name' => $product_name,
                'product_code' => $product_code,
                'product_alert_qty' => $alert_quty,
                'product_unit' => $unit,
                'product_cost' => $product_cost,
                'product_price' => $product_price,
                'wholesale_price' => $wholesale_price,
                'credit_salling_price' => $credit_salling_price,
                'tax' => $tax,
                'product_details' => $product_details,
                'product_part_no' => $product_part_no,
                'product_oem_part_number' => $product_oem_part_number,
                'store_position' => $store_position,
                'product_max_qty' => $product_max_qty,
                'daily_rental_days' => $daily_rental_days,
                'rep_commision' => $rep_commisison,
                'down_payment' => $down_payment,
                'per_day_rental' => $per_day_rental,
                'retail_cash' => $retail_cash,
                'retail_credit' => $retail_credit,
                'retail_wholesale' => $retail_wholesale,
                'brand_id' => $brand_id,
                'is_hw' => $is_hw,
                'warehouse_id' => $warehouse_id,
                'pr_quantity' => $quantity,
                'supp_id' => $supp_id,
                'group_discount'=>$group_discount
            );
            if (!empty($_FILES["userfile"]['name'])) {
                $image_name_enc = "PRODUCT_" . time() . $_FILES["userfile"]['name'];
                $this->load->library('upload', $this->image_manipulation->image_config($image_name_enc));
                if (!$this->upload->do_upload()) {
                    $st = array(
                        'status' => 0,
                        'validation' => $this->upload->display_errors()
                    );
                    echo json_encode($st);
                    exit();
                } else {
                    $this->load->library('image_lib', $this->image_manipulation->image_thumb($image_name_enc, 100, 100));
                    if (!$this->image_lib->resize()) {
                        echo $this->image_lib->display_errors();
                    } else {
                        $imgName             = $this->upload->data();
                        $imageThumb          = $imgName['raw_name'] . "_thumb" . $imgName['file_ext'];
                        $pd['product_image'] = $imgName['file_name'];
                        $pd['product_thumb'] = $imageThumb;
                        $this->image_lib->clear();
                    }
                }
            }
            $last_id = $this->product_models->save_product($pd);
            if ($last_id && $product_code == "") {
                $this->product_models->update_product_code($last_id);
            }
            if ($last_id) {
                $st = array(
                    'status' => 1,
                    'validation' => 'Done!',
                    'last_id' => "PD" . sprintf("%04d", $last_id + 1)
                );
                echo json_encode($st);
            } else {
                $st = array(
                    'status' => 0,
                    'validation' => 'error occurred please contact your system administrator'
                );
                echo json_encode($st);
            }
        }
    }
    function edit_product()
    {
        $product_name             = $this->input->post('product_name');
        $product_code             = $this->input->post('product_code');
        $category                 = $this->input->post('category');
        $subcategory              = $this->input->post('subcategory');
        $unit                     = $this->input->post('unit');
        $product_cost             = $this->price_filter($this->input->post('product_cost'));
        $product_price            = $this->price_filter($this->input->post('product_price'));
        $wholesale_price          = $this->price_filter($this->input->post('wholesale_price'));
        $credit_salling_price     = $this->price_filter($this->input->post('credit_salling_price'));
        $retail_cash              = $this->price_filter($this->input->post('retail_cash'));
        $retail_credit            = $this->price_filter($this->input->post('retail_credit'));
        $retail_wholesale         = $this->price_filter($this->input->post('retail_wholesale'));
        $product_mrp              = $this->price_filter($this->input->post('product_mrp'));
        $brand_id                 = $this->input->post('brand_id');
        $is_hw                    = $this->input->post('is_hw');
        $tax                      = $this->input->post('tax');
        $alert_quty               = $this->input->post('alert_quty');
        $product_details          = $this->input->post('product_details');
        $product_part_no          = $this->input->post('product_part_no');
        $product_oem_part_number  = $this->input->post('product_oem_part_number');
        $store_position           = $this->input->post('store_position');
        $product_max_qty          = $this->input->post('product_max_qty');
        $daily_rental_days        = $this->input->post('daily_rental_days');
        $is_special_rep_commisson = $this->input->post('is_special_rep_commisson');
        $commission_cash_within   = $this->input->post('commission_cash_within');
        $commission_cash_after    = $this->input->post('commission_cash_after');
        $commission_credit_within = $this->input->post('commission_credit_within');
        $commission_credit_after  = $this->input->post('commission_credit_after');
        $warehouse_id             = $this->input->post("warehouse_id");
        $sub_product_of           = $this->input->post('sub_product_of');
        $quantity                 = $this->input->post('pr_quantity');
        $supp_id                 = $this->input->post('supp_id');
        $group_discount          = $this->input->post('group_discount');
        $rep_commisison           = ""; //$this->price_filter($this->input->post('rep_commisison'));            
        $down_payment             = ""; //$this->price_filter($this->input->post('down_payment'));
        $per_day_rental           = ""; //$this->price_filter($this->input->post('per_day_rental'));
        //array
        $pd                       = array(
            'cat_id' => $category,
            'sub_cat_id' => $subcategory,
            'product_name' => $product_name,
            'product_code' => $product_code,
            'product_alert_qty' => $alert_quty,
            'product_unit' => $unit,
            'product_cost' => $product_cost,
            'product_price' => $product_price,
            'wholesale_price' => $wholesale_price,
            'credit_salling_price' => $credit_salling_price,
            'tax' => $tax,
            'product_details' => $product_details,
            'product_part_no' => $product_part_no,
            'product_oem_part_number' => $product_oem_part_number,
            'store_position' => $store_position,
            'product_max_qty' => $product_max_qty,
            'daily_rental_days' => $daily_rental_days,
            'rep_commision' => $rep_commisison,
            'down_payment' => $down_payment,
            'per_day_rental' => $per_day_rental,
            'retail_cash' => $retail_cash,
            'retail_credit' => $retail_credit,
            'retail_wholesale' => $retail_wholesale,
            'product_mrp' => $product_mrp,
            'brand_id' => $brand_id,
            'is_hw' => $is_hw,
            'is_special_rep_commisson' => $is_special_rep_commisson,
            'commission_cash_within' => $commission_cash_within,
            'commission_cash_after' => $commission_cash_after,
            'commission_credit_within' => $commission_credit_within,
            'commission_credit_after' => $commission_credit_after,
            'sub_product_of' => $sub_product_of,
            'warehouse_id' => $warehouse_id,
            'pr_quantity' => $quantity,
            'supp_id' => $supp_id,
            'group_discount'=>$group_discount
        );
        //end array
        if (!empty($_FILES["userfile"]['name'])) {
            $image_name_enc = "PRODUCT_" . time() . $_FILES["userfile"]['name'];
            $this->load->library('upload', $this->image_manipulation->image_config($image_name_enc));
            if (!$this->upload->do_upload()) {
                $st = array(
                    'status' => 0,
                    'validation' => $this->upload->display_errors()
                );
                echo json_encode($st);
                exit();
            } else {
                $this->load->library('image_lib', $this->image_manipulation->image_thumb($image_name_enc, 100, 100));
                if (!$this->image_lib->resize()) {
                    echo $this->image_lib->display_errors();
                } else {
                    $imgName             = $this->upload->data();
                    $imageThumb          = $imgName['raw_name'] . "_thumb" . $imgName['file_ext'];
                    $pd['product_image'] = $imgName['file_name'];
                    $pd['product_thumb'] = $imageThumb;
                    $this->image_lib->clear();
                }
            }
        }
        if ($this->product_models->update_product($this->input->post('product_id'), $pd)) {
            $st = array(
                'status' => 1,
                'validation' => 'Done!'
            );
            echo json_encode($st);
        } else {
            $st = array(
                'status' => 0,
                'validation' => 'error occurred please contact your system administrator'
            );
            echo json_encode($st);
        }
    }
    function price_filter($amount = '')
    {
        $s = explode("Rs.", $amount);
        return str_replace(',', '', $s[1]);
    }
    public function get_list_product($value = '')
    {
        //$this->load->model('Marketing_Delivery_Model');
        $this->load->model('stock_counter_model');
        $search_key     = $this->input->get('search');
        $search_key_val = $search_key['value'];
        $start          = $this->input->get('start');
        $length         = $this->input->get('length');
        $totalData      = 0;
        $values         = $this->product_models->getProducts($start, $length, $search_key_val);
        $value_count    = $this->product_models->getProducts('', '', $search_key_val);
        /*if ($search_key_val) {
        $values_c  = $this->product_models->getProducts('', '', $search_key_val);
        $totalData = 100; //count($values_c);    
        }*/
        $totalData      = $value_count;
        $totalFiltered  = $totalData;
        $open           = "";
        $close          = "";
        $data           = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                $k = '';
                if ($products->product_status == 0) {
                    $k = "btn-danger";
                    $m = "fa-minus-circle";
                } else {
                    $k = "btn-green";
                    $m = "fa-check";
                }
                if ($products->product_status == 0) {
                    $open  = '<a class="list-group-item list-group-item-danger">';
                    $close = '</a>';
                } else if ($products->product_status == 1) {
                    $open  = '<a class="list-group-item" style="border: none; background: inherit">';
                    $close = '</a>';
                }
                $retVal          = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name;
                $row             = array();
                $ss_warehouse_id = ""; //$this->session->userdata('ss_warehouse_id');
                /*$transferd_qty       = $this->Transfer_Model->getTransferdQtyByWarehouseId($ss_warehouse_id, $products->product_id);
                $transfer_reseve_qty = $this->Transfer_Model->getTransferResevedQtyByWarehouseId($ss_warehouse_id, $products->product_id);
                $purchased_qty       = $this->Purchases_Model->getPurchasedQtyByWarehouseId($ss_warehouse_id, $products->product_id);
                $product_damaged_qty = $this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($ss_warehouse_id, $products->product_id);
                $sales_return_qty    = $this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($ss_warehouse_id, $products->product_id);
                $sales_return_qty_hw    = $this->Sales_Return_Model->getSalesReturnQtyByWarehouseId_hw($ss_warehouse_id, $products->product_id);
                $issue_qty           = $this->Customer_Order_Process_Model->get_all_cus_isued_item($ss_warehouse_id, $products->product_id);
                $return_qty          = $this->Customer_Order_Process_Model->get_all_cus_return_item($ss_warehouse_id, $products->product_id);
                $direct_sale_qty     = $this->Sales_Model->get_direct_sale_qty($ss_warehouse_id, $products->product_id);
                $hw_sale_qty         = $this->Pos_Model->get_hw_sale_qty($ss_warehouse_id,$products->product_id,"","");
                $mp       = $this->Bulk_Break_Model->getMpBreakQty($ss_warehouse_id, $products->product_id);
                $sp          = $this->Bulk_Break_Model->getSpBreakQty($ss_warehouse_id, $products->product_id);
                $qty                 = $purchased_qty - $issue_qty + $return_qty - $product_damaged_qty + $transfer_reseve_qty - $transferd_qty-$direct_sale_qty - $mp + $sp -$hw_sale_qty + $sales_return_qty_hw;*/
                $qty             = 0;
                $bdata           = $this->Pos_Model->bdata(($products->sub_product_of) ? $products->sub_product_of : $products->product_id, 'product_price');
                foreach ($bdata as $key => $btc) {
                    $bdata[$key]['qty'] = $this->stock_counter_model->get_stock_balance_batch("", ($products->sub_product_of) ? $products->sub_product_of : $products->product_id, $btc['batch_id']);
                    $qty += ($bdata[$key]['qty'] > 0) ? $bdata[$key]['qty'] : 0;
                }
                /*$msg = "transferd_qty:".$transferd_qty."<br>";
                $msg .= "transfer_reseve_qty:".$transfer_reseve_qty."<br>";
                $msg .= "purchased_qty:".$purchased_qty."<br>";
                $msg .= "product_damaged_qty:".$product_damaged_qty."<br>";
                $msg .= "sales_return_qty:".$sales_return_qty."<br>";
                $msg .= "issue_qty:".$issue_qty."<br>";
                $msg .= "return_qty:".$return_qty."<br>";
                $msg .= "direct_sale_qty:".$direct_sale_qty."<br>";
                $msg .= "hw_sale_qty:".$hw_sale_qty."<br>";*/
                $broker_discount_enable = $this->Broker_Model->check_broker_discount_enable($products->product_id);
                if ($broker_discount_enable > 0) {
                    $br_st = "<span class='btn btn-info btn-xs'> Broker Discount Enable </span>";
                } else {
                    $br_st = "";
                }
                $row[]  = '<div style="margin-bottom: 0px; width: 50px; height: 50px;" class="fileupload-new thumbnail"><img alt="" src="' . asset_url() . "uploads/thumbs/" . $products->product_thumb . '"></div>';
                $row[]  = $open . $products->product_code . $close;
                $row[]  = $open . $products->product_name . $close . $br_st;
                $row[]  = $open . $products->cat_name . $close;
                $row[]  = $retVal;
                $bbreak = '';
                if ($this->common_model->check_permission(117, $this->session->userdata('ss_group_id'), 1)) {
                    $row[]  = $products->product_cost;
                    $bbreak = '<li><a onclick="break_product(' . $products->product_id . '); return false;" href="#"><i class="fa fa-star"></i> Break Product</a></li>';
                }
                if ($this->session->userdata['ss_dept_id'] == 1) {
                    $row[] = $open . $products->retail_wholesale . $close;
                    $row[] = $open . $products->retail_credit . $close;
                    $row[] = $open . $products->retail_cash . $close;
                } else {
                    $row[] = $open . $products->wholesale_price . $close;
                    $row[] = $open . $products->credit_salling_price . $close;
                    $row[] = $open . $products->product_price . $close;
                }
                $row[]   = $open . $qty . $close;
                $actdes  = '';
                $disable = '<li><a style="cursor: pointer;" onclick="disable_product(' . $products->product_id . ')"><i class="glyphicon fa fa-minus-circle"></i> Disable Product</a></li>';
                $enable  = '<li><a style="cursor: pointer;" onclick="enable_product(' . $products->product_id . ')"><i class="glyphicon fa fa-plus-circle"></i> Enable Product</a></li>';
                $actdes  = $actdes . '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs ' . $k . ' dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            <li><a href="' . base_url('products/view') . '/' . $products->product_id . '"><i class="fa fa-file-text-o"></i> Product Details</a></li>
                            ';
                if ($this->common_model->check_permission(113, $this->session->userdata('ss_group_id'), 1)) {
                    if ($products->product_status == 0) {
                        $actdes .= $enable;
                    } else if ($products->product_status == 1) {
                        $actdes .= $disable;
                    }
                }
                if ($this->common_model->check_permission(112, $this->session->userdata('ss_group_id'), 1)) {
                    $actdes = $actdes . '
                            <li><a href="' . base_url('products/edit') . '/' . $products->product_id . '"><i class="fa fa-edit"></i> Edit Product</a></li>
                            
                           <!-- <li class="divider"></li><li><a onclick="product_delete(' . $products->product_id . '); return false;" href="#"><i class="fa fa-trash-o"></i> Delete Product</a></li> -->
                            ';
                }
                //'.$bbreak.'
                $actdes = $actdes . '    
                            <li><a onclick=" print_barcode(' . $products->product_id . '); return false;" href="#"><i class="fa fa-print"></i> Print Barcode</a></li>
                            <li><a onclick=" print_barcode_test(' . $products->product_id . '); " href="#"><i class="fa fa-print"></i> Test Barcode</a></li>
                            <li><a onclick="print_barcode_flex(' . $products->product_id . '); return false;" href="#"><i class="fa fa-print"></i> Flex Barcode</a></li>
                            </ul></div>';
                $row[]  = $actdes;
                $data[] = $row;
            }
            $output = array(
                'data' => $data,
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered)
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    public function view($product_id = "")
    {
        $this->load->model('Batch_Process_Model');
        $this->load->model('Broker_Model');
        $this->load->model('stock_counter_model');
        $sd = $this->product_models->get_product_by_id($product_id);
        if (!empty($sd)) {
            $data['product_details']      = $this->product_models->get_product_by_id($product_id);
            if($data['product_details']->sub_product_of)
                    $data['sub_product_details'] = $this->product_models->get_product_by_id($data['product_details']->sub_product_of);
            $data['warehouses']           = $this->product_models->get_warehouse_product($product_id);
            $data['item_discount_list']   = $this->Product_Discount_Model->get_item_discount_list($product_id);
            $data['broker_discount_list'] = $this->Broker_Model->get_item_discount_list($product_id);
            $data['batch_list']           = $this->Batch_Process_Model->get_batch_list_by_product_id($product_id);
            $warehouse_id = 4;
            
                foreach($data['batch_list'] as $key=>$row){
                    $rr = $this->stock_counter_model->get_stock_balance_batch($warehouse_id, ($data['product_details']->sub_product_of) ? $data['product_details']->sub_product_of : $data['product_details']->product_id, $row->batch_id);
                    $data['batch_list'][$key]->quantity = $rr;
                }
            
            $data['main_menu_name']       = $this->main_menu_name;
            $data['sub_menu_name']        = $this->sub_menu_name;
            $this->load->view('product/view_product', $data);
        } else {
            show_404();
        }
    }
    public function edit($product_id = '')
    {
        $this->load->model('Supplier_Model');
        if ($this->common_model->check_permission(112, $this->session->userdata('ss_group_id'), 1)) {
            $data['suppliers'] = $this->Supplier_Model->get_all_supplier();
            $data['main_menu_name']  = $this->main_menu_name;
            $data['sub_menu_name']   = $this->sub_menu_name;
            $data['main_category']   = $this->category_models->getCategory();
            $data['unit_type']       = $this->product_models->getUnit();
            $data['warehouse_list']  = $this->Warehouse_Model->get_all_warehouse();
            //$data['tax']             = $this->product_models->getTax();
            $data['product_details'] = $this->product_models->get_product_by_id($product_id);
            if (!empty($data['product_details'])) {
                $data['sub_category'] = $this->category_models->getSubCategory($data['product_details']->cat_id);
                if($data['product_details']->sub_product_of)
                    $data['sub_product_details'] = $this->product_models->get_product_by_id($data['product_details']->sub_product_of);
                $this->load->view('product/edit_product', $data);
            } else
                show_404();
        } else
            show_404();
    }
    public function single_barcode($product_id = '')
    {
        $data['product_details'] = $this->product_models->get_product_by_id($product_id);
        $this->load->view('barcode/product_barcode', $data);
    }
    public function single_barcode_test($product_id = '')
    {
        $data['product_details'] = $this->product_models->get_product_by_id($product_id);
        $this->load->view('barcode/product_barcode_test', $data);
    }
    function flex_barcode($product_id = '')
    {
        $data['product_details'] = $this->product_models->get_product_by_id($product_id);
        $this->load->view('barcode/flex_barcode', $data);
    }
    function batch_barcode($batch_id = '', $count = 1)
    {
        $data['batch_data'] = $this->Pos_Model->binfo_by_batch_id($batch_id);
        $data['row_count']  = $count;
        $this->load->view('barcode/batch_barcode', $data);
    }
    function gen_barcode($product_code = NULL, $height = 80)
    {
        if ($this->input->get('code')) {
            $product_code = $this->input->get('code');
        }
        if ($this->input->get('height')) {
            $height = $this->input->get('height');
        }
        //load library
        $this->load->library('zend');
        //load in folder Zend
        $this->zend->load('Zend/Barcode');
        //'drawText' => FALSE
        $barcodeOptions  = array(
            'text' => $product_code,
            'barHeight' => $height,
            'stretchText' => TRUE
        );
        $rendererOptions = array(
            'imageType' => 'png',
            'horizontalPosition' => 'center',
            'verticalPosition' => 'middle'
        );
        $imageResource   = Zend_Barcode::render('code128', 'image', $barcodeOptions, $rendererOptions);
        return $imageResource;
    }
    function delete_product($product_id = '')
    {
        $d = $this->product_models->delete_product($this->input->post('product_id'));
        if ($d) {
            $e = array(
                'status' => 1
            );
            echo json_encode($e);
        } else {
            $e = array(
                'status' => 0,
                'validation' => 'This product is already linked. You cannot delete it.'
            );
            echo json_encode($e);
        }
    }
    public function enable()
    {
        $product_id = $this->input->get('product_id');
        $result     = $this->product_models->enable($product_id);
        return $result;
    }
    public function disable()
    {
        $product_id = $this->input->get('product_id');
        $result     = $this->product_models->disable($product_id);
        return $result;
    }
    public function getProducts()
    {
        $str    = $this->input->get('search_string');
        $result = $this->product_models->get_search_products($str);
        echo json_encode($result);
    }
}