<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class send_sms extends CI_Controller {

    var $main_menu_name = "sms";
	var $sub_menu_name = "sms";

	public function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Colombo");
		$this->load->model('sms_model');
		$this->load->model('customer_model');
		$this->load->model('Common_Model');
	}
	
	//Sales list page load
	public function index()
	{	
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		$data['hw_cus'] = $this->customer_model->get_sms_customer_retail();
		$data['ds_cus'] = $this->customer_model->get_sms_customer_wholesale();
        $this->load->view('sms/send_sms_view',$data);
	}
	
	function send_sms($dest,$msg){
	    $this->load->model("sms_model");//echo $_SERVER['CONTENT_TYPE'];
        $result = $this->sms_model->send_sms($dest,$msg);
        $st = array(
            'status' => $result,
            'msg' => $result,
            'dest'=> $dest,
            'txt' =>$msg
        );
        return $st;
	}
	function set_params(){
	    $incomingContentType = $_SERVER['CONTENT_TYPE'];
        
        if ($_SERVER['CONTENT_TYPE'] !== "application/json" && $_SERVER['CONTENT_TYPE'] !== "application/json; charset=utf-8") {
            header($_SERVER['SERVER_PROTOCOL'] . '500 Internal Server Error');
            exit();
        }
        
        $_POST        = json_decode(file_get_contents("php://input"), true);
        
        $msg = $this->input->post('msg');
        $dest      = $this->input->post('dest');
        if ($msg == "" || $dest == "") {
            $st = array(
                'status' => 0,
                'msg' => 'Error!',
                'dest'=> $dest
            );
            echo json_encode($st);
            exit;
        }
        $st = $this->send_sms($dest,$msg);
        echo json_encode($st);
	}
}