<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Return_Damage_Cus_Model extends CI_Model {
  
  private $tableName = 'cus_damage_return';
  
  function __construct() 
  {
    parent::__construct();
  }
 function  get_all_damage_cus_details(){
	    $this->db->select('cus_damage.cus_damage_id,cus_damage.recieved_date,cus_damage.reference_no,cus_damage.sale_id,cus_damage.cus_id,cus_damage_item.product_id,cus_damage_item.quantity,product.product_name,product.product_code,customer.cus_name,sales.sale_reference_no,sales.card_ref_number');
		$this->db->join('cus_damage_item','cus_damage.cus_damage_id = cus_damage_item.cus_damage_id ','left outer');
		$this->db->join('product','cus_damage_item.product_id=product.product_id','left');
		$this->db->join('customer','cus_damage.cus_id=customer.cus_id','left');
		$this->db->join('sales','cus_damage.sale_id=sales.sale_id','left');
		//$this->db->group_by("cus_damage.cus_damage_id");		
		$this->db->order_by("cus_damage.cus_damage_id", "desc");
		$query = $this->db->get('cus_damage');
		//echo $this->db->last_query();
		return $query->result_array();
	 
	 }
function get_damage_cus_details($id){
	 	$this->db->select('*');
		$this->db->join('cus_damage','sales.sale_id = cus_damage.sale_id','left');
		//$this->db->order_by("product_name", "asc");
		$this->db->where("cus_damage_id",$id);
		//$this->db->limit(10,0);
		$query = $this->db->get('sales');
		//echo $this->db->last_query();
		return $query->row_array();
	  
	 } 

	 
function cus_reference_details($id){
	  $this->db->select('*');
	  $this->db->from('sales');
	  $this->db->where('sale_id',$id);
	  //$this->db->order_by('cus_damage_id','desc');
	  $query=$this->db->get();
	  return $query->result_array();	
	 }

function get_sale_details($id){
	  $this->db->select('*');
	  $this->db->from('sales');
	  $this->db->where('sale_id',$id);
	  //$this->db->order_by('cus_damage_id','desc');
	  $query=$this->db->get();
	  return $query->result_array();	
}
 public function warehouse_info($id)
	 {
		$this->db->select('*');
		$this->db->from('warehouses');
		$this->db->where("id", $id);
		$this->db->order_by("id", "desc");
		$query = $this->db->get();
		
		return $query->result_array(); 
	 }
	 public function get_avalable_product_qt($inc_id,$product_id){
	    $this->db->select('quantity');
		$this->db->from('cus_damage_item');
		$this->db->where("cus_damage_id",$inc_id );
		$this->db->where("product_id",$product_id);
        $query = $this->db->get();
		return $query->result_array(); 
}
    function get_products_suggestions($inc_id,$term,$product) {
		$this->db->select('product.*');
		$this->db->join('cus_damage_item','product.product_id = cus_damage_item.product_id ','left');
		$this->db->order_by("product_name", "asc");
		$this->db->where("cus_damage_item.cus_damage_id",$inc_id);
		$this->db->where("cus_damage_item.product_id",$product);
		//$this->db->limit(10,0);
		$query = $this->db->get('product');
		//echo $this->db->last_query();
		return $query->result_array();
}
function save_product_damage_customer(&$supplier_data,$id)
{
	if (!$id)
		{
			$this->db->insert($this->tableName,$supplier_data);
		}else {
			$this->db->where('id',$id);
			return $this->db->update($this->tableName,$supplier_data);
		}
		
}
 public function cus_product_return_details($cus_damage_id,$product_id){
	    $this->db->select('quantity');
		$this->db->from('cus_damage_return');
		$this->db->where("cus_damage_id",$cus_damage_id );
		$this->db->where("product_id",$product_id);
        $query = $this->db->get();
		return $query->row_array(); 
}
public function get_product_damage_quantity($product_id,$cus_damage_id){
	    $this->db->select('quantity');
		$this->db->from('cus_damage_return');
		$this->db->where("cus_damage_id",$cus_damage_id );
		$this->db->where("product_id",$product_id);
        $query = $this->db->get();
		return $query->row_array(); 
	
	}
public function get_customer_details($cus_id){
	  $this->db->select('*');
	  $this->db->from('customer');
	  $this->db->where("cus_id",$cus_id);
	  $query=$this->db->get();
	  return $query->result_array();
	  
}
public function get_cus_damage_item_qty($product_id,$inc_id){
    $this->db->select_sum('quantity');
	$this->db->from('cus_damage_item');
    $this->db->where('cus_damage_id',$inc_id);
	$this->db->where('product_id',$product_id);
    $query = $this->db->get();
    return $query->result_array();
}
public function get_avalable_product_return_qt($product_id,$inc_id){
    $this->db->select_sum('quantity');
	$this->db->from('cus_damage_return');
    $this->db->where('cus_damage_id',$inc_id);
	$this->db->where('product_id',$product_id);
    $query = $this->db->get();
    return $query->row_array();
	
	  

}
public function get_quantity($cus_damage_id,$product_id){
	   $this->db->select('quantity');
	   $this->db->from('cus_damage_return');
	   $this->db->where("cus_damage_id",$cus_damage_id);
	   $this->db->where("product_id ",$product_id);
	   $query = $this->db->get();
	   if ($query->num_rows() == 0){
         return FALSE;} else{
         return $query->row_array();}
	  
	
}
function get_sale_ref_no($id){
	 	$this->db->select('*');
		$this->db->join('cus_damage','sales.sale_id = cus_damage.sale_id','left');
		//$this->db->order_by("product_name", "asc");
		$this->db->where("cus_damage_id",$id);
		//$this->db->limit(10,0);
		$query = $this->db->get('sales');
		//echo $this->db->last_query();
		return $query->result_array();

}

}